<?php

namespace App\models\sales\relation;

use App\models\stock\Saleable;
use App\models\sales\CreditNote;
use App\models\sales\relation\Addable;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemSalableCreditNote extends Addable
{
    //
    use SoftDeletes;
    protected $table = 'credit_note_items';

    public function creditnote()
    {
        return $this->belongsTo(CreditNote::class, 'credit_notes_id');
    }

    public function saleable()
    {
        return $this->belongsTo(Saleable::class, 'saleable_id');
    }
}
