<?php

namespace App\models\sales\relation;

use App\models\stock\Saleable;
use App\models\sales\DeliveryNote;
use App\models\sales\relation\Addable;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemSalableDeliveryNote extends Addable
{
    //
    use SoftDeletes;
    protected $table = 'delivery_notes_items';

     public function intermediate()
    {
        return $this->deliveryNote();
    }


    public function deliveryNote()
    {
        return $this->belongsTo(DeliveryNote::class, 'delivery_notes_id');
    }

    public function saleable()
    {
        return $this->belongsTo(Saleable::class, 'saleable_id');
    }
}
