<?php

namespace App\models\sales\relation;

use App\models\sales\Invoice;
use App\models\stock\Saleable;
use App\models\sales\relation\Addable;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemSalableInvoice extends Addable
{
    //
    use SoftDeletes;
    protected $table = 'invoice_items';

     public function intermediate()
    {
        return $this->invoice();
    }


    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoices_id');
    }

    public function saleable()
    {
        return $this->belongsTo(Saleable::class, 'saleable_id');
    }
}
