<?php

namespace App\models\sales\relation;

use App\models\sales\InvoicesbyDelivery;
use App\models\stock\Saleable;
use App\models\sales\relation\Addable;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemSaleableInvoiceByDelivery extends Addable
{
    use SoftDeletes;
    protected $table = 'invoicesbydelivery_items';

    protected $fillable = [
        'invoicesbydelivery_id',
        'saleable_id',
        'sale_code',
        'sale_name',
        'quantity',
        'unit_amount',
        'discount',
        'vat_tax',
    ];

     public function intermediate()
    {
        return $this->invoice();
    }


    public function invoicebydeliverynotes()
    {
        return $this->belongsTo(InvoicesbyDelivery::class, 'invoicesbydelivery_id');
    }

    public function saleable()
    {
        return $this->belongsTo(Saleable::class, 'saleable_id');
    }
}
