<?php

namespace App\models\sales\utils;

use App\InvoicerModel;
use App\models\sales\Receipt;
use App\models\sales\CashSale;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankPayment extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'bank_payments';


    public function receipt()
    {
        return $this->hasOne(Receipt::class, 'bank_payments_id');
    }

    public function cashsale()
    {
        return $this->hasOne(CashSale::class, 'bank_payments_id');
    }
}
