<?php

namespace App\models\sales\utils;

use App\InvoicerModel;
use App\models\sales\Basic;
use App\models\sales\Receipt;
use App\models\sales\CashSale;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentMethod extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'payment_methods';
    protected $fillable = ['name', 'slug'];



    public function receipts()
    {
        return $this->hasMany(Receipt::class, 'payment_methods_id');
    }
    public function cashSales()
    {
        return $this->hasMany(CashSale::class, 'payment_methods_id');
    }
    public function basicSales()
    {
        return $this->hasMany(Basic::class, 'payment_methods_id');
    }




    public static function bankpos()
    {
        return static::where('slug', 'bankpos')->first();
    }
    public static function bankcheck()
    {
        return static::where('slug', 'bankcheck')->first();
    }
    public static function banktransfer()
    {
        return static::where('slug', 'banktransfer')->first();
    }
    public static function money()
    {
        return static::where('slug', 'money')->first();
    }
    public static function systemadvance()
    {
        return static::where('slug', 'systemadvance')->first();
    }

    public static function crmpoints()
    {
        return static::where('slug', 'crmpoints')->first();
    }

    public static function providerAdvance()
    {
        return static::where('slug', 'provider_advance')->first() ?? static::createNew('Provider Advance', 'provider_advance');
    }
    public static function createNew($name, $slug)
    {
        $paymentType = new static();
        $paymentType->name = $name;
        $paymentType->slug = $slug;
        $paymentType->save();
        return $paymentType;
    }
}
