<?php

namespace App\models\shifts;


use Carbon\Carbon;
use App\InvoicerModel;
use App\models\users\User;
use App\models\sales\Basic;
use App\models\sales\Invoice;
use App\models\sales\InvoicesbyDelivery;
use App\models\sales\Receipt;
use App\models\company\Brunch;
use App\models\sales\CashSale;
use App\models\sales\Proforma;
use App\models\stock\Category;
use App\models\stock\Saleable;
use App\models\sales\DebitNote;
use App\models\sales\CreditNote;
use App\models\sales\DeliveryNote;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableBasic;
use App\models\sales\relation\ItemSalableInvoice;
use App\models\sales\relation\ItemSalableCashSale;
use App\models\sales\relation\ItemSalableDebitNote;
use App\models\sales\relation\ItemSalableCreditNote;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Shift extends InvoicerModel
{
    use SoftDeletes;
    use HasRelationships;


    protected $table = 'shifts';

    public static function table()
    {
        return 'shifts';
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'users_id');
    }

    public function closedByUser()
    {
        return $this->belongsTo(User::class, 'closed_by_users_id');
    }


    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }


    public function proformas()
    {
        return $this->hasMany(Proforma::class, 'shifts_id');
    }

    public function creditNotes()
    {
        return $this->hasMany(CreditNote::class, 'shifts_id');
    }

    public function debitNotes()
    {
        return $this->hasMany(DebitNote::class, 'shifts_id');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'shifts_id');
    }

    public function invoicesbydelivery()
    {
        return $this->hasMany(InvoicesbyDelivery::class, 'shifts_id');
    }

    public function deliveryNotes()
    {
        return $this->hasMany(DeliveryNote::class, 'shifts_id');
    }

    public function receipts()
    {
        return $this->hasMany(Receipt::class, 'shifts_id');
    }

    public function basicSales()
    {
        return $this->hasMany(Basic::class, 'shifts_id');
    }
    public function cashSales()
    {
        return $this->hasMany(CashSale::class, 'shifts_id');
    }









    public function isOpen()
    {
        return is_null($this->ended_at);
    }

    public function openedAt()
    {
        return $this->started_at->format('d/m/Y H:i');
    }

    public function closedAt()
    {
        return $this->isOpen() ? null : (new Carbon($this->ended_at))->format('d/m/Y H:i');
    }
    public function close(User $user)
    {
        $this->closedByUser()->associate($user);
        $this->ended_at = now();
        $this->save();

        $this->creditNotes()->where('validated_at', null)
            ->forceDelete();
        $this->debitNotes()->where('validated_at', null)
            ->forceDelete();
        $this->invoices()->where('validated_at', null)
            ->forceDelete();
        $this->receipts()->where('validated_at', null)
            ->forceDelete();
        $this->basicSales()->where('validated_at', null)
            ->forceDelete();
        $this->cashSales()->where('validated_at', null)
            ->forceDelete();
    }

    public function duration()
    {
        $ended = new Carbon($this->ended_at);
        return $ended->diffInHours($this->started_at);
        return $ended->diffForHumans($this->started_at);
    }

    public function sum($collection)
    {
        return $collection->sum(function ($item) {
            return $item->totalAmount();
        });
    }

    public function entries()
    {
        return ($this->sum($this->basicSales()->where('validated_at', '<>', null)->get()) +
            $this->sum($this->cashSales()->where('validated_at', '<>', null)->get()) +
            // $this->sum($this->creditNotes) +
            $this->sum($this->receipts()->where('validated_at', '<>', null)->get())
        );
    }

    public function invoices_recipts(){

        return (
            $this->sum($this->invoices()->where('validated_at', '<>', null)->get()) + $this->sum($this->debitNotes()->where('validated_at', '<>', null)->get())
            +$this->sum($this->invoicesbydelivery()->where('validated_at', '<>', null)->get()))
            -$this->sum($this->receipts()->where('validated_at', '<>', null)->get());
    }
    public function outputs()
    {
        return $this->invoices_recipts()
               +$this->sum($this->deliveryNotes()->where('validated_at', '<>', null)->get())
               -$this->sum($this->invoicesbydelivery()->where('validated_at', '<>', null)->get()) ;
    }


    public function saleables()
    {
        $arr1 = $this->saleableViaBasicSales()->pluck(Saleable::table() . '.id')->toArray();
        $arr2 = $this->saleableViaInvoices()->pluck(Saleable::table() . '.id')->toArray();
        $arr3 = $this->saleableViaCashSales()->pluck(Saleable::table() . '.id')->toArray();
        $arr4 = $this->saleableViaCreditNotes()->pluck(Saleable::table() . '.id')->toArray();
        $arr5 = $this->saleableViaDebitNotes()->pluck(Saleable::table() . '.id')->toArray();

        $array = array_merge($arr1, $arr2);
        $array = array_merge($array, $arr3);
        $array = array_merge($array, $arr4);
        $array = array_merge($array, $arr5);
        $saleables = Saleable::whereIn('id', $array)->get();

        foreach ($saleables as $key => $saleable) {
            # code...

            $saleable->sold_quantity = 0;
            $saleable->sold_quantity = $saleable->sold_quantity + $this->addableCreditNotes()->whereHas('saleable', function ($query) use ($saleable) {
                return $query->where(Saleable::table() . '.id', $saleable->id);
            })->sum('quantity');
            $saleable->sold_quantity = $saleable->sold_quantity + $this->addableDebitNotes()->whereHas('saleable', function ($query) use ($saleable) {
                return $query->where(Saleable::table() . '.id', $saleable->id);
            })->sum('quantity');
            $saleable->sold_quantity = $saleable->sold_quantity + $this->addableInvoices()->whereHas('saleable', function ($query) use ($saleable) {
                return $query->where(Saleable::table() . '.id', $saleable->id);
            })->sum('quantity');
            $saleable->sold_quantity = $saleable->sold_quantity + $this->addableBasicSales()->whereHas('saleable', function ($query) use ($saleable) {
                return $query->where(Saleable::table() . '.id', $saleable->id);
            })->sum('quantity');
            $saleable->sold_quantity = $saleable->sold_quantity + $this->addableCashSales()->whereHas('saleable', function ($query) use ($saleable) {
                return $query->where(Saleable::table() . '.id', $saleable->id);
            })->sum('quantity');
        }

        return $saleables;
    }

    public function categories()
    {
        $arr1 = $this->categoriesViaCreditNotes()->pluck(Saleable::table() . '.id')->toArray();
        $arr2 = $this->categoriesViaDebitNotes()->pluck(Saleable::table() . '.id')->toArray();
        $arr3 = $this->categoriesViaInvoices()->pluck(Saleable::table() . '.id')->toArray();
        $arr4 = $this->categoriesViaBasicSales()->pluck(Saleable::table() . '.id')->toArray();
        $arr5 = $this->categoriesViaCashSales()->pluck(Saleable::table() . '.id')->toArray();

        $array = array_merge($arr1, $arr2);
        $array = array_merge($array, $arr3);
        $array = array_merge($array, $arr4);
        $array = array_merge($array, $arr5);
        $categories =  Category::whereIn('id', $array)->get();

        foreach ($categories as $key => $category) {
            $category->sold_quantity = 0;

            $category->sold_quantity = $category->sold_quantity + $this->addableCreditNotes()->whereHas('saleable', function ($query) use ($category) {
                return $query->whereHas('categories', function ($query) use ($category) {
                    return $query->where(Category::table() . '.id', $category->id);
                });
            })->sum('quantity');

            $category->sold_quantity = $category->sold_quantity + $this->addableDebitNotes()->whereHas('saleable', function ($query) use ($category) {
                return $query->whereHas('categories', function ($query) use ($category) {
                    return $query->where(Category::table() . '.id', $category->id);
                });
            })->sum('quantity');
            $category->sold_quantity = $category->sold_quantity + $this->addableInvoices()->whereHas('saleable', function ($query) use ($category) {
                return $query->whereHas('categories', function ($query) use ($category) {
                    return $query->where(Category::table() . '.id', $category->id);
                });
            })->sum('quantity');
            $category->sold_quantity = $category->sold_quantity + $this->addableBasicSales()->whereHas('saleable', function ($query) use ($category) {
                return $query->whereHas('categories', function ($query) use ($category) {
                    return $query->where(Category::table() . '.id', $category->id);
                });
            })->sum('quantity');
            $category->sold_quantity = $category->sold_quantity + $this->addableCashSales()->whereHas('saleable', function ($query) use ($category) {
                return $query->whereHas('categories', function ($query) use ($category) {
                    return $query->where(Category::table() . '.id', $category->id);
                });
            })->sum('quantity');
        }

        return $categories;
    }

    /* Helper relations */
    public function addableCreditNotes()
    {
        return $this->hasManyDeepFromRelations($this->creditNotes(), (new CreditNote())->saleItens());
    }
    public function addableDebitNotes()
    {
        return $this->hasManyDeepFromRelations($this->debitNotes(), (new DebitNote())->saleItens());
    }
    public function addableInvoices()
    {
        return $this->hasManyDeepFromRelations($this->invoices(), (new Invoice())->saleItens());
    }
    public function addableBasicSales()
    {
        return $this->hasManyDeepFromRelations($this->basicSales(), (new Basic())->saleItens());
    }
    public function addableCashSales()
    {
        return $this->hasManyDeepFromRelations($this->cashSales(), (new CashSale())->saleItens());
    }

    public function saleableViaCreditNotes()
    {
        return $this->hasManyDeepFromRelations($this->addableCreditNotes(), (new ItemSalableCreditNote())->saleable());
    }
    public function saleableViaDebitNotes()
    {
        return $this->hasManyDeepFromRelations($this->addableDebitNotes(), (new ItemSalableDebitNote())->saleable());
    }
    public function saleableViaInvoices()
    {
        return $this->hasManyDeepFromRelations($this->addableInvoices(), (new ItemSalableInvoice())->saleable());
    }
    public function saleableViaBasicSales()
    {
        return $this->hasManyDeepFromRelations($this->addableBasicSales(), (new ItemSalableBasic())->saleable());
    }
    public function saleableViaCashSales()
    {
        return $this->hasManyDeepFromRelations($this->addableCashSales(), (new ItemSalableCashSale())->saleable());
    }

    public function categoriesViaCreditNotes()
    {
        return $this->hasManyDeepFromRelations($this->saleableViaCreditNotes(), (new Saleable())->categories());
    }
    public function categoriesViaDebitNotes()
    {
        return $this->hasManyDeepFromRelations($this->saleableViaDebitNotes(), (new Saleable())->categories());
    }
    public function categoriesViaInvoices()
    {
        return $this->hasManyDeepFromRelations($this->saleableViaInvoices(), (new Saleable())->categories());
    }
    public function categoriesViaBasicSales()
    {
        return $this->hasManyDeepFromRelations($this->saleableViaBasicSales(), (new Saleable())->categories());
    }
    public function categoriesViaCashSales()
    {
        return $this->hasManyDeepFromRelations($this->saleableViaCashSales(), (new Saleable())->categories());
    }
    /* Helper relations */
}
