<?php

namespace App\models\stock;

use App\InvoicerModel;
use App\models\company\Brunch;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends InvoicerModel
{
    use SoftDeletes;

    protected $table = 'category';

    public static function table()
    {
        return 'category';
    }


    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }



    public function saleables()
    {
        return $this->belongsToMany(Saleable::class, 'saleable_has_category', 'category_id', 'saleable_id');
    }
}
