<?php

namespace App\models\stock;

use App\InvoicerModel;
use App\models\company\Brunch;
use App\models\stock\Saleable;
use Illuminate\Database\Eloquent\SoftDeletes;

class SaleUnit extends InvoicerModel
{
    //
    use SoftDeletes;

    protected $table = 'sale_units';

    public function saleables()
    {
        return $this->hasMany(Saleable::class, 'sale_units_id');
    }

    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }

}
