<?php

namespace App\models\stock;

use Carbon\Carbon;
use App\InvoicerModel;
use App\models\company\Brunch;
use App\models\stock\Category;
use App\models\stock\SaleUnit;
use App\models\stock\StockMove;
use App\models\stock\VatScheme;
use App\models\stock\Warehouse;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableBasic;
use App\models\sales\relation\ItemSalableInvoice;
use App\models\sales\relation\ItemSalableCashSale;
use App\models\sales\relation\ItemSalableDebitNote;
use App\models\sales\relation\ItemSalableCreditNote;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Saleable extends InvoicerModel
{

    use SoftDeletes;
    use HasRelationships;

    protected $table = 'saleable';
    protected $fillable = ['temp'];

    public static function table()
    {
        return 'saleable';
    }

    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }

    public function saleUnit()
    {
        return $this->belongsTo(SaleUnit::class, 'sale_units_id');
    }
    public function vatScheme()
    {
        return $this->belongsTo(VatScheme::class, 'vat_scheme_id');
    }
    public function categories()
    {
        return $this->belongsToMany(Category::class, 'saleable_has_category', 'saleable_id', 'category_id');
    }

    public function hasCategory(Category $category): bool
    {
        return $this->categories()->where(Category::table() . '.id', $category->id)->exists() ?  true : false;
    }

    public function stockMoves()
    {
        return $this->hasMany(StockMove::class, 'saleable_id');
    }

    public function stockMovesByWarehouse(Warehouse $warehouse)
    {
        return $this->stockMoves()->whereHas('warehouse', function ($query) use ($warehouse) {
            return $query->where(Warehouse::table() . '.id', $warehouse->id);
        })
            ->where('validated_at', '<>', null)
            ->orderBy('validated_at', 'DESC');
    }

    public function lastStockMove(Warehouse $warehouse = null)
    {
        if ($warehouse)
           return $this->stockMovesByWarehouse($warehouse)
                ->first();

        return $this->stockMoves()
            ->where('validated_at', '<>', null)
            ->orderBy('validated_at', 'DESC')
            ->first();
    }

    /* Sales */

    public function salesOnPeriod(Carbon $from, Carbon $to)
    {
        $amount = $this->basicSalesItems()->whereHas('basic', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })
            ->sum(DB::raw('quantity*(unit_amount-discount)'));


        $quantity =  $this->basicSalesItems()->whereHas('basic', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })
            ->sum(DB::raw('quantity'));


        $amount = $amount + $this->cashSalesItems()->orWhereHas('cashsale', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum(DB::raw('quantity*(unit_amount-discount)'));

        $quantity = $quantity + $this->cashSalesItems()->orWhereHas('cashsale', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum('quantity');

        $amount = $amount + $this->debitNotesItems()->orWhereHas('debitnote', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum(DB::raw('quantity*(unit_amount-discount)'));

        $quantity = $quantity +  $this->debitNotesItems()->orWhereHas('debitnote', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum('quantity');

        $amount = $amount + $this->invoicesItems()->orWhereHas('invoice', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum(DB::raw('quantity*(unit_amount-discount)'));

        $quantity = $quantity +  $this->invoicesItems()->orWhereHas('invoice', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum('quantity');

        $amount = $amount - $this->creditNotesItems()->orWhereHas('creditnote', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum(DB::raw('quantity*(unit_amount-discount)'));

        $quantity = $quantity - $this->creditNotesItems()->orWhereHas('creditnote', function ($query) use ($from, $to) {
            return $query
                ->where('validated_at', '>=', $from)
                ->where('validated_at', '<=', $to)
                ->where('anuled_at', '=', null);
        })->sum('quantity');

        return [
            'amount' => $amount,
            'quantity' => $quantity,
        ];
    }

    public function basicSalesItems()
    {
        return $this->hasMany(ItemSalableBasic::class, 'saleable_id');
    }
    public function basicSales()
    {
        return $this->hasManyDeepFromRelations($this->basicSalesItems(), (new ItemSalableBasic())->basic());
    }

    public function cashSalesItems()
    {
        return $this->hasMany(ItemSalableCashSale::class, 'saleable_id');
    }
    public function cashSales()
    {
        return $this->hasManyDeepFromRelations($this->cashSalesItems(), (new ItemSalableCashSale())->cashsale());
    }


    public function invoicesItems()
    {
        return $this->hasMany(ItemSalableInvoice::class, 'saleable_id');
    }
    public function invoices()
    {
        return $this->hasManyDeepFromRelations($this->invoicesItems(), (new ItemSalableInvoice())->invoice());
    }

    public function creditNotesItems()
    {
        return $this->hasMany(ItemSalableCreditNote::class, 'saleable_id');
    }
    public function creditNotes()
    {
        return $this->hasManyDeepFromRelations($this->creditNotesItems(), (new ItemSalableCreditNote())->creditnote());
    }

    public function debitNotesItems()
    {
        return $this->hasMany(ItemSalableDebitNote::class, 'saleable_id');
    }
    public function debitNotes()
    {
        return $this->hasManyDeepFromRelations($this->debitNotesItems(), (new ItemSalableDebitNote())->debitnote());
    }
    /* Sales */
}
