<?php

namespace App\models\stock;

use Carbon\Carbon;
use App\InvoicerModel;
use App\models\users\User;
use App\models\stock\Saleable;
use App\models\stock\Warehouse;
use App\models\provider\Purchase;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class StockMove extends InvoicerModel
{

    use SoftDeletes;
    use HasRelationships;


    protected $table = 'stock_moves';

    protected $casts = [
        'coast' => 'float',
    ];

    public function saleable()
    {
        return $this->belongsTo(Saleable::class, 'saleable_id');
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class, 'warehouses_id');
    }

    public function purchase()
    {
        return $this->belongsTo(Purchase::class, 'purchases_id');
    }

    public function moveType()
    {
        return $this->belongsTo(StockMoveType::class, 'stock_move_types_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'users_id');
    }

    public function company()
    {
        return $this->hasOneDeepFromRelations($this->user(), (new User)->company());
    }

    public function isValid()
    {
        return !is_null($this->validated_at);
    }

    public function totalAmount()
    {
        return abs($this->quantity * $this->unit_price);
    }

    public function validate()
    {
        $this->validated_at = now();
        $move = $this->saleable->lastStockMove($this->warehouse);
        /* tem mais a ser feito */
        $this->balance = $this->quantity + ($move ? $move->balance : 0);
        $this->save();
    }

    public static function transfer(Saleable $saleable, Warehouse $warehouse, User  $user,  $quantity)
    {
        $move = $saleable->lastStockMove($warehouse);
        $price = 0;
        if ($move) {
            $price = abs($quantity * $move->unit_price);
        }
        return static::move($saleable, $warehouse, StockMoveType::transference(), $user, $quantity, $price);
    }

    public static function adjust(Saleable $saleable, Warehouse $warehouse, $quantity, User $user)
    {
        $move = $saleable->lastStockMove($warehouse);
        $price = 0;
        if ($move) {
            if ($move->balance > $quantity)
                $quantity = 0 - ($move->balance - $quantity);
            else
                $quantity =   $quantity - $move->balance;
            $price = abs($quantity * $move->unit_price);
        }
        return static::move($saleable, $warehouse, StockMoveType::adjust(), $user, $quantity, $price);
    }

    public static function move(Saleable $saleable, Warehouse $warehouse, StockMoveType $moveType, User $user, float $quantity, float $price, $expiry_date = null)
    {
        $move = new StockMove();
        $move->saleable()->associate($saleable);
        $move->warehouse()->associate($warehouse);
        $move->quantity  = $quantity;

        if($price>0){
            $move->coast = $price;
        } else{
            $move->coast = 0;
        }


        if ($quantity)
            $move->unit_price  = abs($price / $quantity);
        else
            $move->unit_price  = abs($price);



        if ($expiry_date) {
            $move->expirity_date  = new Carbon($expiry_date);
        }
        $move->moveType()->associate($moveType);
        $move->user()->associate($user);
        $move->save();
        return $move;
    }
}
