<?php

namespace App\models\stock;

use App\InvoicerModel;
use App\models\stock\StockMove;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockMoveType extends InvoicerModel
{
    //
    use SoftDeletes;
    protected $table = 'stock_move_types';

    public function stockMoves()
    {
        return $this->hasMany(StockMove::class, 'stock_move_types_id');
    }

    public static function adjust()
    {
        return static::where('slug', 'adjust')->first();
    }
    public static function sale()
    {
        return static::where('slug', 'sale')->first();
    }
    public static function entry()
    {
        return static::where('slug', 'entry')->first();
    }
    public static function transference()
    {
        return static::where('slug', 'transference')->first();
    }
    public static function return()
    {
        return static::where('slug', 'return')->first();
    }
}
