<?php

namespace App\models\stock;

use App\InvoicerModel;
use Illuminate\Database\Eloquent\SoftDeletes;

class VatScheme extends InvoicerModel
{
    use SoftDeletes;

    protected $table = 'vat_scheme';

    public function saleables()
    {
        return $this->hasMany(Saleable::class, 'vat_scheme_id');
    }

    public function multiplyFactor()
    {
        return $this->tax / 100;
    }

    public static function normal(){
        return static::where('tax', 17)->first();
    }
    public static function exemption(){
        return static::where('tax', 0)->first();
    }
}
