<?php

namespace App\models\stock;

use App\InvoicerModel;
use App\models\company\Brunch;
use App\models\stock\Category;
use App\models\stock\StockMove;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Warehouse extends InvoicerModel
{
    use SoftDeletes;
    use HasRelationships;


    protected $table = 'warehouses';

    public static function table()
    {
        return 'warehouses';
    }

    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }

    public function stockMoves()
    {
        return $this->hasMany(StockMove::class, 'warehouses_id');
    }

    public function saleables()
    {
        return $this->hasManyDeepFromRelations($this->stockMoves(), (new StockMove())->saleable());
    }

    public function categories()
    {
        return $this->hasManyDeepFromRelations($this->saleables(), (new Saleable())->categories());
    }

    public function lastMove(Saleable $saleable)
    {
        return $this->stockMoves()->whereHas('saleable', function ($query) use ($saleable) {
            return $query->where('id', $saleable->id);
        })
            ->where('validated_at', '<>', null)
            ->orderBy('validated_at', 'DESC')
            ->first();
    }

    public function lastMoveByQty(Saleable $saleable, $condition, $qty)
    {
        return $this->stockMoves()->whereHas('saleable', function ($query) use ($saleable) {
            return $query->where('id', $saleable->id);
        })
            ->where('validated_at', '<>', null)->where('balance', $condition, $qty)
            ->orderBy('validated_at', 'DESC')
            ->first();
    }

    public function ExpiredSaleables(Saleable $saleable, $date)
    {
        return $this->stockMoves()->whereHas('saleable', function ($query) use ($saleable) {
            return $query->where('id', $saleable->id);
        })
            ->where('validated_at', '<>', null)->where('expirity_date', '<', $date)
            ->orderBy('validated_at', 'DESC')
            ->first();
    }

    /* helpers */
    public function saleablesInventory($categories = null)
    {
        if ($categories)
            $saleables = $this->saleables()
                ->whereHas('categories', function ($query) use ($categories) {
                    return $query->whereIn(Category::table().'.id', $categories);
                })
                ->distinct()->get();
        else
            $saleables = $this->saleables()
                ->distinct()->get();

        $moves = collect([]);
        foreach ($saleables as $key => $value) {
            $move = $this->lastMove($value);
            if ($move)
                $moves->push($move);
        }
        return $moves;
    }

    public function categoriesInventory()
    {
        $categories = $this->categories()->distinct()->get();

        foreach ($categories as $key => $category) {
            $category->available = $this->stockMoves()->whereHas('saleable', function ($query) use ($category) {
                return $query->whereHas('categories', function ($query) use ($category) {
                    return $query->where(Category::table() . '.id', $category->id);
                });
            })->sum('quantity');
        }
        return $categories;
    }
    /* helpers */
}
