<?php

namespace App\models\stock\transference;

/**
 * Created by Reliese Model.
 */


use Carbon\Carbon;
use App\models\stock\StockMove;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\stock\transference\StockTransferenceGroup;

/**
 * Class StockTransference
 *
 * @property int $id
 * @property Carbon|null $validated_at
 * @property int $stock_transference_groups_id
 * @property int $stock_moves_from
 * @property int $stock_moves_to
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @property StockMove $stock_move
 * @property StockTransferenceGroup $stock_transference_group
 *
 * @package App\models
 */
class StockTransference extends Model
{
	use SoftDeletes;
	protected $table = 'stock_transferences';

	protected $casts = [
		'stock_transference_groups_id' => 'int',
		'stock_moves_from' => 'int',
		'stock_moves_to' => 'int'
	];

	protected $dates = [
		'validated_at'
	];

	protected $fillable = [
		'validated_at',
		'stock_transference_groups_id',
		'stock_moves_from',
		'stock_moves_to'
	];

	public function stockMoveTo()
	{
		return $this->belongsTo(StockMove::class, 'stock_moves_to');
	}

	public function stockMoveFrom()
	{
		return $this->belongsTo(StockMove::class, 'stock_moves_from');
	}
	public function stockTransferenceGroup()
	{
		return $this->belongsTo(StockTransferenceGroup::class, 'stock_transference_groups_id');
	}

	public function group()
	{
		return	$this->stockTransferenceGroup();
	}
}
