<?php
namespace App\models\stock\transference;

/**
 * Created by Reliese Model.
 */


use Carbon\Carbon;
use App\models\users\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class StockTransferenceGroup
 *
 * @property int $id
 * @property Carbon|null $validated_at
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @property Collection|StockTransference[] $stock_transferences
 *
 * @package App\models
 */
class StockTransferenceGroup extends Model
{
	use SoftDeletes;
	protected $table = 'stock_transference_groups';

	protected $dates = [
		'validated_at'
	];

	protected $fillable = [
		'validated_at'
	];

	public function transfers()
	{
		return $this->hasMany(StockTransference::class, 'stock_transference_groups_id');
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'users_id');
	}

	public function isValid()
    {
        return !is_null($this->validated_at);
    }
}
