<?php

namespace App\models\users;

use App\InvoicerModel;
use App\models\users\User;
use App\models\company\SystemFuncionality;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends InvoicerModel
{
    use SoftDeletes;
    public static function table()
    {
        return 'roles';
    }

    public function funcionality()
    {
        return $this->belongsTo(SystemFuncionality::class, 'system_funcionalities_id');
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'users_has_roles', 'roles_id', 'users_id');
    }

    public static function createBasicSale()
    {
        return static::where('slug', 'create_basic_sale')->first();
    }

    public static function showBasicSale()
    {
        return static::where('slug', 'show_basic_sale')->first();
    }

    public static function editBasicSale()
    {
        return static::where('slug', 'edit_basic_sale')->first();
    }

    public static function createCashSale()
    {
        return static::where('slug', 'create_cash_sale')->first();
    }

    public static function showCashSale()
    {
        return static::where('slug', 'show_cash_sale')->first();
    }

    public static function editCashSale()
    {
        return static::where('slug', 'edit_cash_sale')->first();
    }


    public static function createInvoice()
    {
        return static::where('slug', 'create_invoice')->first();
    }

    public static function showInvoice()
    {
        return static::where('slug', 'show_invoice')->first();
    }

    public static function editInvoice()
    {
        return static::where('slug', 'edit_invoice')->first();
    }

    public static function createDeliveryNote()
    {
        return static::where('slug', 'create_delivery-note')->first();
    }

    public static function showDeliveryNote()
    {
        return static::where('slug', 'show_delivery-note')->first();
    }

    public static function editDeliveryNote()
    {
        return static::where('slug', 'edit_delivery-note')->first();
    }

    public static function createDebitNote()
    {
        return static::where('slug', 'create_debit_note')->first();
    }
    public static function showDebitNote()
    {
        return static::where('slug', 'show_debit_note')->first();
    }
    public static function editDebitNote()
    {
        return static::where('slug', 'edit_debit_note')->first();
    }

    public static function createCreditNote()
    {
        return static::where('slug', 'create_credit_note')->first();
    }
    public static function showCreditNote()
    {
        return static::where('slug', 'show_credit_note')->first();
    }
    public static function editCreditNote()
    {
        return static::where('slug', 'edit_credit_note')->first();
    }

    public static function createReceipt()
    {
        return static::where('slug', 'create_receipt')->first();
    }
    public static function showReceipt()
    {
        return static::where('slug', 'show_receipt')->first();
    }
    public static function editReceipt()
    {
        return static::where('slug', 'edit_receipt')->first();
    }

    public static function createProforma()
    {
        return static::where('slug', 'create_proforma')->first();
    }
    public static function showProforma()
    {
        return static::where('slug', 'show_proforma')->first();
    }
    public static function editProforma()
    {
        return static::where('slug', 'edit_proforma')->first();
    }



    public static function manageStock()
    {
        return static::where('slug', 'manage_stocks')->first();
    }

    public static function manageCustomers()
    {
        return static::where('slug', 'manage_customers')->first();
    }



    public static function manageGlobal()
    {
        return static::where('slug', 'global_admin')->first();
    }
    public static function manageLocal()
    {
        return static::where('slug', 'local_admin')->first();
    }
    public static function manageShifts()
    {
        return static::where('slug', 'manage_shifts')->first();
    }
}
