<?php

namespace App\models\users;

use App\Traits\HasShifts;
use App\models\users\Role;
use App\models\company\Brunch;
use App\Traits\CreatesInvoice;
use App\Traits\CreatesRecipts;
use App\Traits\CreatesCashSale;
use App\Traits\CreatesProforma;
use App\Traits\CreatesBasicSale;
use App\Traits\CreatesDebitNote;
use App\Traits\CreatesCreditNote;
use App\Traits\ManagesStock;
use Laravel\Passport\HasApiTokens;
use Illuminate\Support\Facades\Storage;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use SoftDeletes;
    use Notifiable;
    use HasApiTokens;
    use HasRelationships;

    use CreatesBasicSale;
    use CreatesCashSale;
    use CreatesCreditNote;
    use CreatesDebitNote;
    use CreatesInvoice;
    use CreatesProforma;
    use CreatesRecipts;
    use ManagesStock;
    use HasShifts;


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password','invisible'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public static function table()
    {
        return 'users';
    }

    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }

    public function brunch()
    {
        return $this->company();
    }


    public function isJustSeller()
    {
        return !$this->roles()->where(Role::table() . '.id', '<>', Role::createBasicSale()->id)->exists();
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'users_has_roles', 'users_id', 'roles_id');
    }

    public function hasRole(Role $role): bool
    {
        return $this->roles()->where(Role::table() . '.id', $role->id)->exists() ?  true : false;
    }

    public function profilePhoto()
    {
        if (Storage::disk('public')->exists($this->image)) {
            $file = $this->image;
            $data = Storage::disk('public')->get($file);
        } else {
            $file = 'imgs/no-photo.jpg';
            $path = public_path($file);
            $data = file_get_contents($path); //This is an alternative to Storage::get('xyz) the contents of the file using native php function
        }

        $type = pathinfo($file, PATHINFO_EXTENSION);
        return 'data:image/' . $type . ';base64,' . base64_encode($data);
    }

    public function adminlte_image()
    {
        return $this->profilePhoto();
    }

    public function adminlte_desc()
    {
        return 'That\'s a nice guy';
    }

    public function adminlte_profile_url()
    {
        return 'web.system.home';
    }
}
