<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Title
    |--------------------------------------------------------------------------
    |
    | Here you can change the default title of your admin panel.
    |
    | For detailed instructions you can look the title section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'title' => env('APP_NAME'),
    'title_prefix' => '',
    'title_postfix' => '',

    /*
    |--------------------------------------------------------------------------
    | Favicon
    |--------------------------------------------------------------------------
    |
    | Here you can activate the favicon.
    |
    | For detailed instructions you can look the favicon section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'use_ico_only' => false,
    'use_full_favicon' => false,

    /*
    |--------------------------------------------------------------------------
    | Logo
    |--------------------------------------------------------------------------
    |
    | Here you can change the logo of your admin panel.
    |
    | For detailed instructions you can look the logo section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'logo' => '<b>' . env('APP_NAME') . '</b>',
    'logo_img' => 'favicon.jpg',
    'logo_img_class' => 'brand-image img-circle elevation-3',
    'logo_img_xl' => null,
    'logo_img_xl_class' => 'brand-image-xs',
    'logo_img_alt' =>  env('APP_NAME'),


    /*
    |--------------------------------------------------------------------------
    | User Menu
    |--------------------------------------------------------------------------
    |
    | Here you can activate and change the user menu.
    |
    | For detailed instructions you can look the user menu section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'usermenu_enabled' => true,
    'usermenu_header' => true,
    'usermenu_header_class' => 'bg-primary',
    'usermenu_image' => true,
    'usermenu_desc' => true,
    'usermenu_profile_url' => true,

    /*
    |--------------------------------------------------------------------------
    | Layout
    |--------------------------------------------------------------------------
    |
    | Here we change the layout of your admin panel.
    |
    | For detailed instructions you can look the layout section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'layout_topnav' => null,
    'layout_boxed' => null,
    'layout_fixed_sidebar' => true,
    'layout_fixed_navbar' => null,
    // 'layout_fixed_footer' => null,
    'layout_fixed_footer' => true,

    /*
    |--------------------------------------------------------------------------
    | Authentication Views Classes
    |--------------------------------------------------------------------------
    |
    | Here you can change the look and behavior of the authentication views.
    |
    | For detailed instructions you can look the auth classes section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'classes_auth_card' => 'card-outline card-primary',
    'classes_auth_header' => '',
    'classes_auth_body' => '',
    'classes_auth_footer' => '',
    'classes_auth_icon' => '',
    'classes_auth_btn' => 'btn-flat btn-outline-primary',


    /*
    |--------------------------------------------------------------------------
    | Admin Panel Classes
    |--------------------------------------------------------------------------
    |
    | Here you can change the look and behavior of the admin panel.
    |
    | For detailed instructions you can look the admin panel classes here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */
    'classes_body' => '',
    'classes_brand' => '',
    'classes_brand_text' => '',
    'classes_content_header' => 'container-fluid',
    'classes_content' => 'container-fluid',


    'classes_sidebar' => "sidebar-light-primary elevation-4", //bom

    'classes_sidebar_nav' => '',
    'classes_topnav' => 'navbar-white navbar-light',
    'classes_topnav_container' => 'container',

    'classes_content_wrapper' => '',
    'classes_topnav_nav' => 'navbar-expand',

    /*
    |--------------------------------------------------------------------------
    | Sidebar
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar of the admin panel.
    |
    | For detailed instructions you can look the sidebar section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'sidebar_mini' => 'lg',
    'sidebar_collapse' => true,
    'sidebar_collapse_auto_size' => false,
    'sidebar_collapse_remember' => true,
    'sidebar_collapse_remember_no_transition' => true,
    'sidebar_scrollbar_theme' => 'os-theme-light',
    'sidebar_scrollbar_auto_hide' => 'l',
    'sidebar_nav_accordion' => true,
    'sidebar_nav_animation_speed' => 300,

    /*
    |--------------------------------------------------------------------------
    | Control Sidebar (Right Sidebar)
    |--------------------------------------------------------------------------
    |
    | Here we can modify the right sidebar aka control sidebar of the admin panel.
    |
    | For detailed instructions you can look the right sidebar section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Layout-and-Styling-Configuration
    |
    */

    'right_sidebar' => true,
    'right_sidebar_icon' => 'fas fa-cogs',
    'right_sidebar_theme' => 'dark',
    'right_sidebar_slide' => true,
    'right_sidebar_push' => true,
    'right_sidebar_scrollbar_theme' => 'os-theme-light',
    'right_sidebar_scrollbar_auto_hide' => 'l',

    /*
    |--------------------------------------------------------------------------
    | URLs
    |--------------------------------------------------------------------------
    |
    | Here we can modify the url settings of the admin panel.
    |
    | For detailed instructions you can look the urls section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Basic-Configuration
    |
    */

    'use_route_url' => true,

    'dashboard_url' => 'web.system.home',

    'logout_url' => 'logout',

    'login_url' => 'login',

    'register_url' => null,

    'password_reset_url' => 'password.request',

    'password_email_url' => 'password.email',
    'profile_url' => 'web.user.profile',

    /*
    |--------------------------------------------------------------------------
    | Laravel Mix
    |--------------------------------------------------------------------------
    |
    | Here we can enable the Laravel Mix option for the admin panel.
    |
    | For detailed instructions you can look the laravel mix section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Other-Configuration
    |
    */

    'enabled_laravel_mix' => false,
    'laravel_mix_css_path' => 'css/app.css',
    'laravel_mix_js_path' => 'js/app.js',

    /*
    |--------------------------------------------------------------------------
    | Menu Items
    |--------------------------------------------------------------------------
    |
    | Here we can modify the sidebar/top navigation of the admin panel.
    |
    | For detailed instructions you can look here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Menu-Configuration
    |
    */


    'menu' => [
        'MENU PRINCIPAL',
        [
            'text' => 'Meu Painel',
            'route'  => 'web.system.home',
            'icon' => 'fas fa-fw fa-home',
        ],

        // ['header' => 'Vendas'],

        // [
        //     'text' => 'Simples',
        //     'route'  => 'web.sales.basic.create',
        //     'icon' => 'fas fa-fw fa-tag',
        //     'can'  => 'issue-basicsale'
        // ],
        // [
        //     'text'  => 'Retorno',
        //     'route' => 'web.sales.returns.create',
        //     'icon'  => 'fas fa-fw fa-undo',
        //     'can'   => 'manage-shifts'
        // ],

        // [
        //     'text'    => 'Emitir',
        //     'icon'    => 'fas fa-fw fa-money-bill',
        //     'can' => 'issue-advanced-sales',
        //     'submenu' => [
        //         [
        //             'text' => 'Venda dinheiro',
        //             'route'  => 'web.sales.cashsale.create',
        //             'can'  => 'issue-cashsale'
        //         ],

        //         [
        //             'text' => 'Fatura',
        //             'route'  => 'web.sales.invoice.create',
        //             'can'  => 'issue-invoice'
        //         ],

        //         [
        //             'text' => 'Nota de crédito',
        //             'route'  => 'web.sales.creditnote.create',
        //             'can'  => 'issue-creditnote',

        //         ], [
        //             'text' => 'Nota de débito',
        //             'route'  => 'web.sales.debitnote.create',
        //             'can'  => 'issue-debitnote'
        //         ], [
        //             'text' => 'Recibos',
        //             'route'  => 'web.sales.recipt.create',
        //             'can'  => 'issue-recipt'
        //         ], [
        //             'text' => 'Proforma',
        //             'route'  => 'web.sales.proforma.create',
        //             'can'  => 'issue-proforma'
        //         ],
        //         [
        //             'text' => 'Guia de remessa',
        //             'route'  => 'web.sales.delivery_note.create',
        //              'can'  => 'issue-delivery_note'

        //         ],

        //     ],
        // ],



        ['header' => 'Relatórios', 'can'=>'check-company-full-reports'],
        [
            'text' => 'Resumo',
            'route'  => 'web.sales.report.summary',
            'icon' => 'fas fa-fw fa-globe',
            'can' => 'check-company-full-reports'
        ], [
            'text' => 'Gerador',
            'route'  => 'web.sales.report.generate',
            'icon' => 'fas fa-file-alt  fa-fw',
            'can' => 'check-company-full-reports'
        ],
        [
            'text'    => 'Particulares',
            'icon'    => 'fas fa-fw fa-calculator',
            'can' => 'check-company-particular-reports',

            'submenu' => [
                [
                    'text' => 'Venda Básica',
                    'route'  => 'web.sales.basic.report',
                    'can' => 'funcionality-basicsale'
                ], [
                    'text' => 'Venda dinheiro',
                    'route'  => 'web.sales.cashsale.report',
                    'can' => 'funcionality-cashsale'
                ], [
                    'text' => 'Fatura',
                    'route'  => 'web.sales.invoice.report',
                    'can' => 'funcionality-invoice'
                ],
                [
                    'text' => 'Fatura Por Guia',
                    'route'  => 'web.sales.invoice.report.by.delivery',
                    'can' => 'funcionality-invoice'
                ],
                [
                    'text' => 'Nota de crédito',
                    'route'  => 'web.sales.creditnote.report',
                    // 'can' => 'funcionality-creditnote'
                    'can' => 'access'

                ], [
                    'text' => 'Nota de débito',
                    'route'  => 'web.sales.debitnote.report',
                    // 'can' => 'funcionality-debitnote'
                    'can' => 'access'

                ], [
                    'text' => 'Recibos',
                    'route'  => 'web.sales.recipt.report',
                    // 'can' => 'funcionality-recipt'
                    'can' => 'access'
                ], [
                    'text' => 'Proforma',
                    'route'  => 'web.sales.proforma.report',
                    'can' => 'funcionality-proforma'
                ],
                [
                    'text' => 'Guia de remessa',
                    'route'  => 'web.sales.deliverynote.report',
                    // 'can'  => 'issue-delivery_note'

                ],
            ],
        ],


        [
            'header' => 'Produtos',
            'can' => 'manage-stock'
        ],
        [
            'text'  => 'Lançamento',
            'route'  => 'web.stock.move.create',
            'icon'  => 'fas fa-fw fa-list',
            'can'   => 'manage-stock'
        ],
        [
            'text' => 'Inventário',
            'route'  => 'web.stock.tools',
            'icon'  => 'fas fa-fw fa-warehouse',
            'can'   => 'manage-stock'

        ],

        [
            'text' => 'Criação',
            'route'  => 'web.stock.saleable.create',
            'icon'  => 'fas fa-fw fa-plus',
            'can'   => 'manage-stock'
        ],

        [
            'text'      => 'Opções',
            'icon'      => 'fas fa-fw fa-cog',
            'can'       => 'manage-stock',
            'submenu' => [
                [
                    'text' => 'Listagem',
                    'route'  => 'web.stock.saleable.index',
                    'can' =>'manage-local'
                ],

                [
                    'text' => 'Ajustes',
                    'route'  => 'web.stock.inventory.adjust',
                    'can' =>'manage-local'
                ],
                [
                    'text' => 'Armazens',
                    'route'  => 'web.stock.warehouse.index',
                ], [
                    'text' => 'Fornecedores',
                    'route'  => 'web.stock.providers.index',
                    'can' =>'manage-local'
                ], [
                    'text' => 'Categorias',
                    'route'  => 'web.stock.category.index',
                ], [
                    'text' => 'Unidades de venda',
                    'route'  => 'web.stock.saleunit.index',
                ],
            ],
        ],

        [
            'header' => 'Clientes',
            'can' => 'manage-customers'
        ],
        [
            'text'  => 'Novo',
            'route'   => 'web.customer.create',
            'icon'  => 'fas fa-fw fa-plus',
            'can'   => 'manage-customers'
        ],
        [
            'text'      => 'Opções',
            'icon'      => 'fas fa-fw fa-cog',
            'can'       => 'manage-customers',
            'submenu' => [
                [
                    'text' => 'Listagem',
                    'route'   => 'web.customer.index',
                ],
                [
                    'text'  => 'Saldos',
                    'route' => 'web.balances',
                    // 'can'   => 'manage-customers'
                    'can'  => 'access'
                ],
            ],
        ],

        [
            'header' => 'Turnos',
            'can' => 'touch-shifts'
        ],
        [
            'text' => 'Atual',
            'route'  => 'web.shift.current',
            'icon' => 'fas fa-fw fa-heartbeat',
            'can' => 'sale'
        ],
        [
            'text'      => 'Opções',
            'icon'      => 'fas fa-fw fa-cog',
            'can'       => 'manage-shifts',
            'submenu' => [
                [
                    'text' => 'Abertos',
                    'route'  => 'web.shift.opened',
                ],
                [
                    'text' => 'Todos',
                    'route'  => 'web.shift.index',
                ],
            ],
        ],
        [
            'header' => 'Sucursais',
            'can' => 'manage-global'
        ],
        [
            'text' => 'Nova',
            'route'  => 'web.company.brunch.create',
            'icon' => 'fas fa-fw fa-user',
            'can' => 'manage-global'

        ],
        [
            'text' => 'Lista',
            'route'  => 'web.company.brunch.index',
            'icon' => 'fas fa-fw fa-lock',
            'can' => 'manage-global'

        ],
        [
            'header' => 'account_settings',
            'can' => 'manage-local'
        ],
        [
            'text' => 'profile',
            'route'  => 'web.user.profile',
            'icon' => 'fas fa-fw fa-user',
            'can' => 'manage-local'
        ],
        [
            'text' => 'Sair',
            'route'  => 'web.system.exit',
            'icon' => 'fas fa-fw fa-times',

        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Menu Filters
    |--------------------------------------------------------------------------
    |
    | Here we can modify the menu filters of the admin panel.
    |
    | For detailed instructions you can look the menu filters section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Menu-Configuration
    |
    */

    'filters' => [
        JeroenNoten\LaravelAdminLte\Menu\Filters\GateFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\HrefFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\SearchFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\ActiveFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\ClassesFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\LangFilter::class,
        JeroenNoten\LaravelAdminLte\Menu\Filters\DataFilter::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Plugins Initialization
    |--------------------------------------------------------------------------
    |
    | Here we can modify the plugins used inside the admin panel.
    |
    | For detailed instructions you can look the plugins section here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Plugins-Configuration
    |
    */

    'plugins' => [

        /* sb */
        [
            'name' => 'sb',
            'active' => true,
            'files' => [
                [
                    'type' => 'js',
                    'location' => 'assets/js/collections.js',
                    'asset' => true,
                ],  [
                    'type' => 'js',
                    'location' => 'assets/js/general.js',
                    'asset' => true,
                ],  [
                    'type' => 'js',
                    'location' => 'assets/js/intl.js',
                    'asset' => true,
                ],  [
                    'type' => 'js',
                    'location' => 'assets/js/oauth.js',
                    'asset' => true,
                ], [
                    'type' => 'js',
                    'location' => 'assets/js/shop.js',
                    'asset' => true,
                ], [
                    'type' => 'js',
                    'location' => 'assets/js/window.js',
                    'asset' => true,
                ], [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'assets/css/main.css'
                ]
            ]
        ],


        /* sb */

        /* Jquery UI */
        [
            'name' => 'JqueryUI',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor\jquery-ui\jquery-ui.min.js'
                ],
            ]
        ],
        /* Jquery UI */
        [
            'name' => 'Datatables',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables/js/jquery.dataTables.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables/js/dataTables.bootstrap4.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'assets/plugins/datatable/datatable.js',
                ],
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/datatables/css/dataTables.bootstrap4.min.css',
                ],
            ],
        ],
        [
            'name' => 'DatatablesGroup',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/rowgroup/js/dataTables.rowGroup.min.js',
                ], [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/rowgroup/js/rowGroup.bootstrap4.min.js',
                ],

                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/rowgroup/css/rowGroup.bootstrap4.min.css'
                ]
            ],
        ],
        [
            'name' => 'DatatablesExport',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/buttons/js/dataTables.buttons.min.js',
                ], [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/buttons/js/buttons.bootstrap4.min.js',
                ], [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/jszip/jszip.min.js',
                ],

                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/buttons/js/buttons.flash.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/buttons/js/buttons.colVis.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/buttons/js/buttons.html5.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/buttons/js/buttons.print.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/datatables-plugins/buttons/css/buttons.bootstrap4.min.css',
                ],

            ],

        ],
        [
            'name' => 'Select2',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/select2/js/select2.full.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/select2/css/select2.min.css',
                ],
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/select2-bootstrap4-theme/select2-bootstrap4.min.css',
                ],
            ],
        ],
        [
            'name' => 'SelectPicker',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/bootstrap-select/dist/js/bootstrap-select.min.js',
                ],
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/bootstrap-select/dist/css/bootstrap-select.min.css',
                ],
            ],
        ],

        [
            'name' => 'BootstrapSwitch',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/bootstrap-switch/js/bootstrap-switch.min.js',
                ], [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'assets/plugins/bootstrap-switch/init.js',
                ],
            ],
        ],
        [
            'name' => 'Handlebars',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor\handlebars\handlebars.min.js',
                ],
            ],
        ],
        /* ChartJs */
        [
            'name' => 'Chartjs',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor\chart.js\Chart.min.js',
                ], [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor\chart.js\Chart.min.css',
                ],
            ],
        ],
        /* ChartJs */

        /* Morris Chart */
        [
            'name' => 'MorrisJs',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor\charts\morris-bundle\raphael.min.js'
                ], [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor\charts\morris-bundle\morris.js'
                ],
                /* demo
                [
                    'type' => 'js',
                    'asset'=> true,
                    'location' => 'vendor\charts\morris-bundle\Morrisjs.js'
                ],
                */ [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor\charts\morris-bundle\morris.css'
                ],
            ],
        ],
        /* Morris Chart */

        /* Sparkline */
        [
            'name' => 'Sparkline',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/sparklines/sparkline.js'
                ]
            ]
        ],
        /* Sparkline */

        /* jqueryknob */
        [
            'name' => 'jqueryknob',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/jquery-knob/jquery.knob.min.js'
                ]
            ]
        ],
        /* jqueryknob */



        /* Sweetalert2 */
        [
            'name' => 'Sweetalert2',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/sweetalert2/sweetalert2.all.min.js',
                ],/* [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/sweetalert2/sweetalert2.min.css',
                ], */ [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css',
                ],
            ],
        ],
        /* Sweetalert2 */

        /* Sweetalert1 */
        [
            'name' => 'Sweetalert1',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/sweetalert1/sweetalert2.all.js',
                ],/* [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/sweetalert2/sweetalert2.min.css',
                ], */ [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/sweetalert1/sweetalert2.css',

                ],
            ],
        ],
        /* Sweetalert1 */
        /* DropzoneJs */
        [
            'name' => 'DropzoneJs',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor\dropzone\src\dropzone.js',
                ], [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'assets\plugins\dropzone\dropzone.js',
                ],
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor\dropzone\src\dropzone.css',
                ],  [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'assets\plugins\dropzone\dropzone.css',
                ],
            ],
        ],
        /* DropzoneJs */

        /* Pace */
        [
            'name' => 'Pace',
            'active' => false,
            'files' => [
                [
                    'type' => 'css',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/themes/blue/pace-theme-center-radar.min.css',
                ],
                [
                    'type' => 'js',
                    'asset' => false,
                    'location' => '//cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/pace.min.js',
                ],
            ],
        ],
        /* Pace */

        /* JqueryValidation */
        [
            'name' => 'JqueryValidation',
            'active' => false,
            'files' => [
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/jquery-validation/jquery.validate.min.js',
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/jquery-validation/additional-methods.min.js',
                ],
            ],
        ],
        /* JqueryValidation */

        /* JsGrid */
        [
            'name' => 'JsGrid',
            'active' => false,
            'files' => [
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/jsgrid/jsgrid.min.css'
                ], [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/jsgrid/jsgrid-theme.min.css'
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/jsgrid/jsgrid.min.js'
                ],
            ]
        ],
        /* JsGrid */

        /* DatePickers */
        [
            'name' => 'Datepicker',
            'active' => false,
            'files' => [
                [
                    'type' => 'css',
                    'asset' => true,
                    'location' => 'vendor/daterangepicker/daterangepicker.css'
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/moment/moment.min.js'
                ],
                [
                    'type' => 'js',
                    'asset' => true,
                    'location' => 'vendor/daterangepicker/daterangepicker.js'
                ],
            ]
        ],
        /* DatePickers */



    ],

    /*
    |--------------------------------------------------------------------------
    | Livewire
    |--------------------------------------------------------------------------
    |
    | Here we can enable the Livewire support.
    |
    | For detailed instructions you can look the livewire here:
    | https://github.com/jeroennoten/Laravel-AdminLTE/wiki/Other-Configuration
    */

    'livewire' => true,
];
