<?php
$image = '';
$pdf = '';

if (env('SERVER_LINUX')) {
    $pdf = base_path('vendor/h4cc/wkhtmltopdf-amd64/bin/wkhtmltopdf-amd64');  // As composer dependency for ubuntu 64 bit
    $image =  base_path('vendor/h4cc/wkhtmltopdf-amd64/bin/wkhtmltoimage-amd64'); // As composer dependency for ubuntu 64 bit
} else if (env('WKPDF_AS_DEPENDENCY')) {
    $pdf = base_path('vendor/wemersonjanuario/wkhtmltopdf-windows/bin/64bit/wkhtmltopdf.exe'); // As composer dependency for Windows 64 bit
    $image =  base_path('vendor/wemersonjanuario/wkhtmltopdf-windows/bin/64bit/wkhtmltoimage.exe'); // As composer dependency for Windows 64 bit
} else {
    $image = '"C:\Program Files\wkhtmltopdf\bin\wkhtmltoimage.exe"';
    $pdf = '"C:\Program Files\wkhtmltopdf\bin\wkhtmltopdf.exe"';
}

return [

    /*
    |--------------------------------------------------------------------------
    | Snappy PDF / Image Configuration
    |--------------------------------------------------------------------------
    |
    | This option contains settings for PDF generation.
    |
    | Enabled:
    |
    |    Whether to load PDF / Image generation.
    |
    | Binary:
    |
    |    The file path of the wkhtmltopdf / wkhtmltoimage executable.
    |
    | Timout:
    |
    |    The amount of time to wait (in seconds) before PDF / Image generation is stopped.
    |    Setting this to false disables the timeout (unlimited processing time).
    |
    | Options:
    |
    |    The wkhtmltopdf command options. These are passed directly to wkhtmltopdf.
    |    See https://wkhtmltopdf.org/usage/wkhtmltopdf.txt for all options.
    |
    | Env:
    |
    |    The environment variables to set while running the wkhtmltopdf process.
    |
    */

    'pdf' => [
        'enabled' => true,
        // 'binary'  => '"/usr/bin/wkhtmltopdf"', // default
        'binary'  => $pdf,
        'timeout' => false,
        'options' => [],
        'env'     => [],
    ],

    'image' => [
        'enabled' => true,
        // 'binary'  => '"/usr/bin/wkhtmltoimage"', // default
        'binary'  => $image,
        'timeout' => false,
        'options' => [],
        'env'     => [],
    ],
];
