<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\models\stock\Saleable;
use App\models\stock\SaleUnit;
use App\models\stock\VatScheme;
use Faker\Generator as Faker;

$factory->define(Saleable::class, function (Faker $faker) {
    return [
        'code'          => $faker->hexColor,
        'name'          => $faker->word,
        'description'   => $faker->word,
        'is_stockable'  => $faker->boolean(),
        'price'         => $faker->randomFloat(2, 10, 100000),
        'sale_units_id' => SaleUnit::all()->random(),
        'vat_scheme_id' => VatScheme::all()->random(),
        'temp'          => 0
    ];
});
