<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\models\users\User;
use Illuminate\Support\Str;
use Faker\Generator as Faker;
use App\models\company\Brunch;
use Illuminate\Support\Facades\Hash;

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| This directory should contain each of the model factory definitions for
| your application. Factories provide a convenient way to generate new
| model instances for testing / seeding your application's database.
|
*/

$factory->define(User::class, function (Faker $faker) {
    return [
        'name'              => $faker->name,
        'email'             => $faker->unique()->safeEmail,
        'email_verified_at' => now(),
        'password'          => Hash::make(1234567890),
        'remember_token'    => Str::random(10),
        'brunch_company_id' => Brunch::all()->random(),
        'invisible'         => 0
    ];
});
