<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRolesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'roles';

    /**
     * Run the migrations.
     * @table roles
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('slug')->nullable();
            $table->unsignedInteger('system_funcionalities_id');

            $table->index(["system_funcionalities_id"], 'fk_roles_system_funcionalities1_idx');

            $table->unique(["slug"], 'slug_UNIQUE');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('system_funcionalities_id', 'fk_roles_system_funcionalities1_idx')
                ->references('id')->on('system_funcionalities')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
