<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBrunchCompanyTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'brunch_company';

    /**
     * Run the migrations.
     * @table brunch_company
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name');
            $table->string('country')->nullable();
            $table->string('city')->nullable();
            $table->string('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('nuit')->nullable();
            $table->unsignedInteger('vat_scheme_id');
            $table->text('logo')->nullable();

            $table->index(["vat_scheme_id"], 'fk_brunch_company_vat_scheme_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('vat_scheme_id', 'fk_brunch_company_vat_scheme_idx')
                ->references('id')->on('company_vat_scheme')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
