<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomersTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'customers';

    /**
     * Run the migrations.
     * @table customers
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('brunch_company_id');
            $table->string('code');
            $table->string('name')->nullable();
            $table->string('nuit')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->tinyInteger('default')->nullable();
            $table->decimal('discount', 8, 2)->nullable();

            $table->index(["brunch_company_id"], 'fk_customers_brunch_company1_idx');

            $table->unique(["code"], 'code_UNIQUE');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('brunch_company_id', 'fk_customers_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
