<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBrunchCompanyHasSystemFuncionalitiesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'brunch_company_has_system_funcionalities';

    /**
     * Run the migrations.
     * @table brunch_company_has_system_funcionalities
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('brunch_company_id');
            $table->unsignedInteger('system_funcionalities_id');

            $table->index(["brunch_company_id"], 'fk_brunch_company_has_system_funcionalities_brunch_company1_idx');

            $table->index(["system_funcionalities_id"], 'fk_brunch_company_has_system_funcionalities_system_funciona_idx');


            $table->foreign('brunch_company_id', 'fk_brunch_company_has_system_funcionalities_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('system_funcionalities_id', 'fk_brunch_company_has_system_funcionalities_system_funciona_idx')
                ->references('id')->on('system_funcionalities')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
