<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBasicSaleConfigTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'basic_sale_config';

    /**
     * Run the migrations.
     * @table basic_sale_config
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->tinyInteger('fast_sale')->nullable();
            $table->unsignedInteger('brunch_company_id');

            $table->index(["brunch_company_id"], 'fk_basic_sale_config_brunch_company1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('brunch_company_id', 'fk_basic_sale_config_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
