<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWarehousesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'warehouses';

    /**
     * Run the migrations.
     * @table warehouses
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('address')->nullable();
            $table->string('contact')->nullable();
            $table->string('responsible')->nullable();
            $table->tinyInteger('selling_werehouse')->nullable()->default('0');
            $table->unsignedInteger('brunch_company_id');

            $table->index(["brunch_company_id"], 'fk_warehouses_brunch_company1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('brunch_company_id', 'fk_warehouses_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
