<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSaleUnitsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'sale_units';

    /**
     * Run the migrations.
     * @table sale_units
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('abbr')->nullable();
            $table->unsignedInteger('brunch_company_id');

            $table->index(["brunch_company_id"], 'fk_sale_units_brunch_company1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('brunch_company_id', 'fk_sale_units_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
