<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCrmConfigTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'crm_config';

    /**
     * Run the migrations.
     * @table crm_config
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->dateTime('enabled_at')->nullable();
            $table->decimal('increment_amount', 8, 2)->nullable();
            $table->decimal('point_amount', 8, 2)->nullable()->comment('This means how much each point is.');
            $table->unsignedInteger('brunch_company_id');

            $table->index(["brunch_company_id"], 'fk_crm_config_brunch_company1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('brunch_company_id', 'fk_crm_config_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
