<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateShiftsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'shifts';

    /**
     * Run the migrations.
     * @table shifts
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->dateTime('started_at');
            $table->dateTime('ended_at')->nullable();
            $table->unsignedInteger('users_id');
            $table->unsignedInteger('closed_by_users_id')->nullable();
            $table->unsignedInteger('brunch_company_id');

            $table->index(["brunch_company_id"], 'fk_shifts_brunch_company1_idx');

            $table->index(["users_id"], 'fk_shifts_users1_idx');

            $table->index(["closed_by_users_id"], 'fk_shifts_users2_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('users_id', 'fk_shifts_users1_idx')
                ->references('id')->on('users')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('brunch_company_id', 'fk_shifts_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('closed_by_users_id', 'fk_shifts_users2_idx')
                ->references('id')->on('users')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
