<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSaleableTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'saleable';

    /**
     * Run the migrations.
     * @table saleable
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('code')->nullable()->default(null);
            $table->string('name');
            $table->text('description')->nullable();
            $table->tinyInteger('is_stockable')->nullable();
            $table->decimal('min_quantity', 8, 2)->nullable();
            $table->decimal('price', 10, 2)->nullable();
            $table->unsignedInteger('sale_units_id');
            $table->unsignedInteger('vat_scheme_id');
            $table->unsignedInteger('brunch_company_id');

            $table->index(["sale_units_id"], 'fk_saleable_sale_units1_idx');

            $table->index(["brunch_company_id"], 'fk_saleable_brunch_company1_idx');

            $table->index(["vat_scheme_id"], 'fk_saleable_vat_scheme1_idx');

            $table->unique(["code"], 'code_UNIQUE');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('sale_units_id', 'fk_saleable_sale_units1_idx')
                ->references('id')->on('sale_units')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('vat_scheme_id', 'fk_saleable_vat_scheme1_idx')
                ->references('id')->on('vat_scheme')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('brunch_company_id', 'fk_saleable_brunch_company1_idx')
                ->references('id')->on('brunch_company')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
