<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerOperationsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'customer_operations';

    /**
     * Run the migrations.
     * @table customer_operations
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('customers_id');
            $table->dateTime('anuled_at')->nullable();
            $table->dateTime('validated_at')->nullable();

            $table->index(["customers_id"], 'fk_customers_statement_customers1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('customers_id', 'fk_customers_statement_customers1_idx')
                ->references('id')->on('customers')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
