<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProformaTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'proforma';

    /**
     * Run the migrations.
     * @table proforma
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('shifts_id');
            $table->unsignedInteger('customer_operations_id')->nullable();
            $table->dateTime('anuled_at')->nullable();
            $table->integer('print_nr')->nullable();
            $table->string('document_sequence')->nullable();
            $table->decimal('financial_discount', 8, 2)->nullable();
            $table->string('customer_name')->nullable();
            $table->string('customer_nuit')->nullable();
            $table->string('customer_address')->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->longText('obs')->nullable();

            $table->index(["customer_operations_id"], 'fk_proforma_customer_operations1_idx');

            $table->index(["shifts_id"], 'fk_proforma_shifts1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('shifts_id', 'fk_proforma_shifts1_idx')
                ->references('id')->on('shifts')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('customer_operations_id', 'fk_proforma_customer_operations1_idx')
                ->references('id')->on('customer_operations')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
