<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStockMovesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'stock_moves';

    /**
     * Run the migrations.
     * @table stock_moves
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->decimal('quantity', 8, 2);
            $table->decimal('balance', 8, 2)->nullable();
            $table->decimal('unit_price', 8, 2)->nullable();
            $table->unsignedInteger('saleable_id');
            $table->unsignedInteger('warehouses_id');
            $table->dateTime('expirity_date')->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->unsignedInteger('providers_id');
            $table->unsignedInteger('stock_move_types_id');
            $table->unsignedInteger('users_id');

            $table->index(["users_id"], 'fk_stock_moves_users1_idx');

            $table->index(["stock_move_types_id"], 'fk_stock_moves_stock_move_types1_idx');

            $table->index(["providers_id"], 'fk_stock_moves_providers1_idx');

            $table->index(["saleable_id"], 'fk_stock_moves_saleable1_idx');

            $table->index(["warehouses_id"], 'fk_stock_moves_warehouses1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('saleable_id', 'fk_stock_moves_saleable1_idx')
                ->references('id')->on('saleable')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('warehouses_id', 'fk_stock_moves_warehouses1_idx')
                ->references('id')->on('warehouses')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('providers_id', 'fk_stock_moves_providers1_idx')
                ->references('id')->on('providers')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('stock_move_types_id', 'fk_stock_moves_stock_move_types1_idx')
                ->references('id')->on('stock_move_types')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('users_id', 'fk_stock_moves_users1_idx')
                ->references('id')->on('users')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
