<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBasicSalesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'basic_sales';

    /**
     * Run the migrations.
     * @table basic_sales
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('shifts_id');
            $table->unsignedInteger('payment_methods_id');
            $table->unsignedInteger('customer_operations_id')->nullable();
            $table->integer('print_nr')->nullable();
            $table->string('document_sequence')->nullable();
            $table->decimal('financial_discount', 8, 2)->nullable();
            $table->string('customer_name')->nullable();
            $table->string('customer_nuit')->nullable();
            $table->string('customer_address')->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->dateTime('anuled_at')->nullable();
            $table->longText('obs')->nullable();

            $table->index(["shifts_id"], 'fk_basic_sales_shifts1_idx');

            $table->index(["customer_operations_id"], 'fk_basic_sales_customer_operations1_idx');

            $table->index(["payment_methods_id"], 'fk_basic_sales_payment_methods1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('shifts_id', 'fk_basic_sales_shifts1_idx')
                ->references('id')->on('shifts')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('payment_methods_id', 'fk_basic_sales_payment_methods1_idx')
                ->references('id')->on('payment_methods')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('customer_operations_id', 'fk_basic_sales_customer_operations1_idx')
                ->references('id')->on('customer_operations')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
