<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSaleableHasCategoryTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'saleable_has_category';

    /**
     * Run the migrations.
     * @table saleable_has_category
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('saleable_id');
            $table->unsignedInteger('category_id');

            $table->index(["saleable_id"], 'fk_saleable_has_category_saleable1_idx');

            $table->index(["category_id"], 'fk_saleable_has_category_category1_idx');


            $table->foreign('saleable_id', 'fk_saleable_has_category_saleable1_idx')
                ->references('id')->on('saleable')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('category_id', 'fk_saleable_has_category_category1_idx')
                ->references('id')->on('category')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
