<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDebitNotesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'debit_notes';

    /**
     * Run the migrations.
     * @table debit_notes
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('shifts_id');
            $table->unsignedInteger('invoices_id')->nullable();
            $table->unsignedInteger('customer_operations_id')->nullable();
            $table->integer('print_nr')->nullable();
            $table->string('document_sequence')->nullable();
            $table->decimal('financial_discount', 8, 2)->nullable();
            $table->string('customer_name')->nullable();
            $table->string('customer_nuit')->nullable();
            $table->string('customer_address')->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->dateTime('anuled_at')->nullable();
            $table->dateTime('due_date')->nullable();
            $table->longText('obs')->nullable();

            $table->index(["invoices_id"], 'fk_debit_notes_invoices1_idx');

            $table->index(["shifts_id"], 'fk_debit_notes_shifts1_idx');

            $table->index(["customer_operations_id"], 'fk_debit_notes_customer_operations1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('shifts_id', 'fk_debit_notes_shifts1_idx')
                ->references('id')->on('shifts')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('invoices_id', 'fk_debit_notes_invoices1_idx')
                ->references('id')->on('invoices')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('customer_operations_id', 'fk_debit_notes_customer_operations1_idx')
                ->references('id')->on('customer_operations')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
