<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBasicSalesItemsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'basic_sales_items';

    /**
     * Run the migrations.
     * @table basic_sales_items
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('basic_sales_id');
            $table->unsignedInteger('saleable_id')->nullable();
            $table->string('sale_code')->nullable();
            $table->string('sale_name')->nullable();
            $table->decimal('quantity', 8, 2)->nullable();
            $table->decimal('unit_amount', 10, 2)->nullable();
            $table->decimal('discount', 8, 2)->nullable();
            $table->decimal('vat_tax', 5, 2)->nullable();

            $table->index(["basic_sales_id"], 'fk_basic_sales_items_basic_sales1_idx');

            $table->index(["saleable_id"], 'fk_basic_sales_items_saleable1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('basic_sales_id', 'fk_basic_sales_items_basic_sales1_idx')
                ->references('id')->on('basic_sales')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('saleable_id', 'fk_basic_sales_items_saleable1_idx')
                ->references('id')->on('saleable')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
