<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerAdvanceTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'customer_advance';

    /**
     * Run the migrations.
     * @table customer_advance
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->decimal('amount', 10, 2);
            $table->dateTime('used_at')->nullable();
            $table->unsignedInteger('recipts_id');
            $table->unsignedInteger('customers_id');

            $table->index(["recipts_id"], 'fk_customer_advance_recipts1_idx');

            $table->index(["customers_id"], 'fk_customer_advance_customers1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('recipts_id', 'fk_customer_advance_recipts1_idx')
                ->references('id')->on('recipts')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('customers_id', 'fk_customer_advance_customers1_idx')
                ->references('id')->on('customers')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
