<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerPointsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'customer_points';

    /**
     * Run the migrations.
     * @table customer_points
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('customers_id');
            $table->unsignedInteger('basic_created_id');
            $table->unsignedInteger('basic_used_by')->nullable();
            $table->decimal('points', 8, 2);

            $table->index(["customers_id"], 'fk_customer_points_customers1_idx');

            $table->index(["basic_created_id"], 'fk_customer_points_basic_sales1_idx');

            $table->index(["basic_used_by"], 'fk_customer_points_basic_sales2_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('customers_id', 'fk_customer_points_customers1_idx')
                ->references('id')->on('customers')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('basic_created_id', 'fk_customer_points_basic_sales1_idx')
                ->references('id')->on('basic_sales')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('basic_used_by', 'fk_customer_points_basic_sales2_idx')
                ->references('id')->on('basic_sales')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
