<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoiceItemsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'invoice_items';

    /**
     * Run the migrations.
     * @table invoice_items
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('invoices_id');
            $table->unsignedInteger('saleable_id')->nullable();
            $table->string('sale_code')->nullable();
            $table->string('sale_name')->nullable();
            $table->decimal('quantity', 8, 2)->nullable();
            $table->decimal('unit_amount', 10, 2)->nullable();
            $table->decimal('discount', 8, 2)->nullable();
            $table->decimal('total_amount', 10, 2)->nullable();
            $table->decimal('vat_tax', 5, 2)->nullable();

            $table->index(["invoices_id"], 'fk_invoice_items_invoices1_idx');

            $table->index(["saleable_id"], 'fk_invoice_items_saleable1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('invoices_id', 'fk_invoice_items_invoices1_idx')
                ->references('id')->on('invoices')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('saleable_id', 'fk_invoice_items_saleable1_idx')
                ->references('id')->on('saleable')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
