<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReciptItemTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'recipt_item';

    /**
     * Run the migrations.
     * @table recipt_item
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('recipts_id');
            $table->unsignedInteger('invoices_id')->nullable();
            $table->unsignedInteger('debit_notes_id')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->decimal('pending', 10, 2)->nullable();

            $table->index(["invoices_id"], 'fk_recipt_item_invoices1_idx');

            $table->index(["debit_notes_id"], 'fk_recipt_item_debit_notes1_idx');

            $table->index(["recipts_id"], 'fk_recipt_item_recipts1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('recipts_id', 'fk_recipt_item_recipts1_idx')
                ->references('id')->on('recipts')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('invoices_id', 'fk_recipt_item_invoices1_idx')
                ->references('id')->on('invoices')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('debit_notes_id', 'fk_recipt_item_debit_notes1_idx')
                ->references('id')->on('debit_notes')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
