<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdvancePaymentsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'advance_payments';

    /**
     * Run the migrations.
     * @table advance_payments
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('customer_advance_id');
            $table->unsignedInteger('recipts_id');
            $table->decimal('amount', 10, 2)->nullable();

            $table->index(["customer_advance_id"], 'fk_advance_payments_customer_advance1_idx');

            $table->index(["recipts_id"], 'fk_advance_payments_recipts1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('customer_advance_id', 'fk_advance_payments_customer_advance1_idx')
                ->references('id')->on('customer_advance')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('recipts_id', 'fk_advance_payments_recipts1_idx')
                ->references('id')->on('recipts')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
