<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDebitNoteItemsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'debit_note_items';

    /**
     * Run the migrations.
     * @table debit_note_items
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('debit_notes_id');
            $table->unsignedInteger('saleable_id')->nullable();
            $table->string('sale_code')->nullable();
            $table->string('sale_name')->nullable();
            $table->decimal('quantity', 8, 2)->nullable();
            $table->decimal('unit_amount', 10, 2)->nullable();
            $table->decimal('discount', 8, 2)->nullable();
            $table->decimal('vat_tax', 5, 2)->nullable();

            $table->index(["saleable_id"], 'fk_debit_note_items_saleable1_idx');

            $table->index(["debit_notes_id"], 'fk_debit_note_items_debit_notes1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('debit_notes_id', 'fk_debit_note_items_debit_notes1_idx')
                ->references('id')->on('debit_notes')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('saleable_id', 'fk_debit_note_items_saleable1_idx')
                ->references('id')->on('saleable')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
