<?php

use Illuminate\Support\Facades\Schema;
use App\models\sales\utils\PaymentMethod;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePurchasesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'purchases';

    /**
     * Run the migrations.
     * @table purchases
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name')->nullable();
            $table->unsignedInteger('providers_id');
            $table->decimal('financial_discount', 8, 2)->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->dateTime('anuled_at')->nullable();
            $table->longText('obs')->nullable();
            $table->longText('attachment')->nullable();

            $table->index(["providers_id"], 'fk_purchases_providers1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('providers_id', 'fk_purchases_providers1_idx')
                ->references('id')->on('providers')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });

        $this->seedDependencies();
    }

    private function seedDependencies(){
        PaymentMethod::firstOrCreate(['name' => 'Provider Advance', 'slug' => 'provider_advance']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
