<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnCustomerOnProvider extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'providers';

    /**
     * Run the migrations.
     * @table providers
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('customers_id')->nullable();
            $table->index(["customers_id"], 'fk_providers_customers1_idx');
            $table->foreign('customers_id', 'fk_providers_customers1_idx')
                ->references('id')->on('customers')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->dropForeign('fk_providers_customers1_idx');
            $table->dropIndex('fk_providers_customers1_idx');
            $table->dropColumn('customers_id');
        });
     }

}
