<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnPurchaseOnStockMove extends Migration
{
   /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'stock_moves';

    /**
     * Run the migrations.
     * @table stock_moves
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('purchases_id')->nullable();
            $table->index(["purchases_id"], 'fk_stock_moves_purchases1_idx');
            $table->foreign('purchases_id', 'fk_stock_moves_purchases1_idx')
                ->references('id')->on('purchases')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->dropForeign('fk_stock_moves_purchases1_idx');
            $table->dropIndex('fk_stock_moves_purchases1_idx');
            $table->dropColumn('purchases_id');
        });
     }
}
