<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveColumnProviderOnStockMove extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'stock_moves';

    /**
     * Run the migrations.
     * @table stock_moves
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->dropForeign('fk_stock_moves_providers1_idx');
            $table->dropIndex('fk_stock_moves_providers1_idx');
            $table->dropColumn('providers_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('providers_id');
            $table->index(["providers_id"], 'fk_stock_moves_providers1_idx');
            $table->foreign('providers_id', 'fk_stock_moves_providers1_idx')
                ->references('id')->on('providers')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }
}
