<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePurchasePaymentsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'purchase_payments';

    /**
     * Run the migrations.
     * @table purchase_payments
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('purchases_id');
            $table->unsignedInteger('recipts_id')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->longText('attachment')->nullable();

            $table->index(["purchases_id"], 'fk_purchase_payments_purchases1_idx');

            $table->index(["recipts_id"], 'fk_purchase_payments_recipts1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('purchases_id', 'fk_purchase_payments_purchases1_idx')
                ->references('id')->on('purchases')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('recipts_id', 'fk_purchase_payments_recipts1_idx')
                ->references('id')->on('recipts')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
